/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.ui_settings.controller;

import jakarta.transaction.Transactional;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Id;
import systems.dennis.shared.annotations.security.SelfOnlyRole;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.postgres.controller.AddItemController;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.postgres.controller.ListItemController;
import systems.dennis.shared.ui_settings.form.TableSettingForm;
import systems.dennis.shared.ui_settings.model.TableSettingModel;
import systems.dennis.shared.ui_settings.service.TableSettingService;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.security.DefaultIdChecker;

@RestController
@RequestMapping(value={"/api/v2/shared/table_setting"})
@WebFormsSupport(value=TableSettingService.class)
@CrossOrigin
public class TableSettingController
extends ApplicationContext
implements AddItemController<TableSettingModel, TableSettingForm>,
ListItemController<TableSettingModel, TableSettingForm>,
DeleteItemController<TableSettingModel> {
    public TableSettingController(WebContext context) {
        super(context);
    }

    @GetMapping(value={"/list_all"})
    @WithRole
    public List<TableSettingForm> findByUserAndTopic(@RequestParam(required=true) String topic) {
        return this.getService().findByUserAndTopic(topic).stream().map(arg_0 -> ((TableSettingController)this).toForm(arg_0)).collect(Collectors.toList());
    }

    @DeleteMapping(value={"/delete/{id}"}, consumes={"application/json", "application/json;charset=UTF-8"}, produces={"application/json", "application/json;charset=UTF-8"})
    @ResponseBody
    @WithRole
    @SelfOnlyRole
    public void delete(@Id(checker=DefaultIdChecker.class) @PathVariable Long id) throws ItemForAddContainsIdException {
        super.delete(id);
    }

    @WithRole
    @RequestMapping(value={"/delete/deleteItems"}, method={RequestMethod.POST})
    @Transactional
    public void deleteItems(@RequestParam List<Long> ids) throws ItemNotUserException, ItemNotFoundException {
        for (Long id : ids) {
            this.delete(id);
        }
    }

    public TableSettingService getService() {
        return (TableSettingService)((Object)this.getBean(TableSettingService.class));
    }
}

