package systems.dennis.shared.ui_settings.form;

import jakarta.persistence.OneToMany;
import lombok.Data;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.ui_settings.model.FieldFormPosition;

import java.util.List;

;

@Data
public class UserFormSettingsForm implements AbstractForm {

    private Long id;
    @OneToMany
    @ObjectByIdPresentation
    private List<FieldFormPosition> positions;
    private String entityType;

    @Override
    public String asValue() {
        return entityType + " " + id;
    }
}
