package systems.dennis.shared.ui_settings.form;

import lombok.Data;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.pojo_form.Checkable;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.DEFAULT_TYPES;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.validation.ValueNotEmptyValidator;

import java.util.List;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.HIDDEN;

@Data
@PojoListView(actions = {"settings"})
public class TableSettingForm implements DefaultForm {

    @PojoFormElement(type = HIDDEN)
    private Long id;

    @Validation(ValueNotEmptyValidator.class)
    @PojoFormElement(required = true)
    @PojoListViewField(searchable = true)
    private String name;


    @PojoFormElement(required = true)
    @PojoListViewField(searchable = true)
    private String topic;

    @PojoFormElement(required = true)
    @PojoListViewField (available = false)
    private List<String> fieldsOrder;

    @PojoFormElement(required = true)
    @PojoListViewField (available = false)
    private List<String> visibleFields;

    @PojoListViewField (available = false)
    private MagicRequest magicQuery;

    @PojoFormElement
    @PojoListViewField (available = false)

    private String url;

    @PojoFormElement(type = DEFAULT_TYPES.CHECKBOX, checked = @Checkable, remote = @Remote(searchType = DEFAULT_TYPES.CHECKBOX))
    @PojoListViewField(searchable = true)
    private Boolean addToMenu;


    @PojoListViewField(actions = {@UIAction(component = "delete")}, visible = false)
    @PojoFormElement(available = false)
    private Integer action;

    @Override
    public String asValue() {
        return name;
    }
}
