/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.ui_settings.service;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.mongo.service.PaginationService;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.ui_settings.form.TableSettingForm;
import systems.dennis.shared.ui_settings.model.TableSettingModel;
import systems.dennis.shared.ui_settings.repository.TableSettingRepo;

@Service
@DataRetrieverDescription(model=TableSettingModel.class, form=TableSettingForm.class, repo=TableSettingRepo.class)
public class TableSettingService
extends PaginationService<TableSettingModel> {
    public TableSettingService(WebContext holder) {
        super(holder);
    }

    public TableSettingModel preAdd(TableSettingModel object) throws ItemForAddContainsIdException {
        Optional obj = this.getRepository().filteredFirst(this.getFilterImpl().eq("topic", (Object)object.getTopic()).and(this.getFilterImpl().eq("name", (Object)object.getName())).and(this.getFilterImpl().ofUser(TableSettingModel.class, (Serializable)((Object)object.getUserDataId()))));
        obj.ifPresent(tableSettingModel -> object.setId(tableSettingModel.getId()));
        return object;
    }

    public List<TableSettingModel> findByUserAndTopic(String topic) {
        return this.getRepository().filteredData(this.getFilterImpl().eq("topic", (Object)topic).and(this.getFilterImpl().ofUser(TableSettingModel.class, this.getCurrentUser())), Pageable.unpaged()).getContent();
    }

    public AbstractDataFilter<TableSettingModel> getAdditionalSpecification() {
        AbstractDataFilter spec = super.getAdditionalSpecification();
        return spec.and(this.getFilterImpl().ofUser(TableSettingModel.class, this.getCurrentUser()));
    }

    public TableSettingRepo getRepository() {
        return (TableSettingRepo)super.getRepository();
    }
}

