package systems.dennis.shared.ui_settings.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.mongo.service.PaginationService;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.ui_settings.form.UserFormSettingsForm;
import systems.dennis.shared.ui_settings.model.UserFormSettingsModel;
import systems.dennis.shared.ui_settings.repository.FieldFormPositionRepository;
import systems.dennis.shared.ui_settings.repository.UserFormSettingsRepo;

import java.io.Serializable;
import java.util.Optional;

@Service
@Slf4j
@DataRetrieverDescription(model = UserFormSettingsModel.class, form = UserFormSettingsForm.class, repo = UserFormSettingsRepo.class)
public class UserFormSettingsService<ID_TYPE extends Serializable> extends PaginationService<UserFormSettingsModel> {
    public UserFormSettingsService(WebContext holder) {
        super(holder);
    }

    @Override
    public UserFormSettingsModel preAdd(UserFormSettingsModel object) throws ItemForAddContainsIdException {

        Optional<UserFormSettingsModel> existing = getRepository().filteredFirst(createUserFormSpecification(object.getEntityType()));
        var positionBean =   getBean(FieldFormPositionRepository.class);
        existing.ifPresent(userFormSettingsModel ->
        {
            object.setId(userFormSettingsModel.getId());
            try {

                positionBean.deleteAll(existing.get().getPositions());
            } catch (Exception e){
                log.info("Cannot delete old items", e);
            }
        });

        positionBean.saveAll(object.getPositions());


        return super.preAdd(object);
    }

    @Override
    public UserFormSettingsRepo getRepository() {
        return super.getRepository();
    }

    public AbstractDataFilter<UserFormSettingsModel> createUserFormSpecification(String entityType) {
        AbstractDataFilter<UserFormSettingsModel> specification = getSelfCreatedItems(getBean(ISecurityUtils.class).getUserDataId(), false);
        var additionalSpecification = getFilterImpl().eq("entityType", entityType);
        return specification.and(additionalSpecification);
    }

}
