package systems.dennis.shared.ui_settings.service;

import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.mongo.service.PaginationService;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.ui_settings.form.TableSettingForm;
import systems.dennis.shared.ui_settings.model.TableSettingModel;
import systems.dennis.shared.ui_settings.repository.TableSettingRepo;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Service
@DataRetrieverDescription(model = TableSettingModel.class, form = TableSettingForm.class, repo = TableSettingRepo.class)
public class TableSettingService extends PaginationService<TableSettingModel> {

    public TableSettingService(WebContext holder) {
        super(holder);
    }

    @Override
    public TableSettingModel preAdd(TableSettingModel object) throws ItemForAddContainsIdException {


        Optional<TableSettingModel> obj = getRepository().filteredFirst(getFilterImpl().eq("topic",
                        object.getTopic()).and(getFilterImpl().eq("name", object.getName()))
                        .and(getFilterImpl().ofUser(TableSettingModel.class, object.getUserDataId())));



        obj.ifPresent(tableSettingModel -> object.setId(tableSettingModel.getId()));

        return object;
    }

    public List<TableSettingModel> findByUserAndTopic(String topic) {

       return getRepository().filteredData(getFilterImpl().eq("topic", topic).and(getFilterImpl().ofUser(getCurrentUser(), TableSettingModel.class)), Pageable.unpaged()).getContent();

    }

    @Override
    public AbstractDataFilter<TableSettingModel> getAdditionalSpecification() {
        var spec = super.getAdditionalSpecification();
        return spec.and(getFilterImpl().ofUser(TableSettingModel.class, getCurrentUser()));
    }

    @Override
    public TableSettingRepo getRepository() {
        return super.getRepository();
    }
}
