package systems.dennis.shared.ui_settings.form;

import jakarta.persistence.OneToMany;
import lombok.Data;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.mongo.form.DefaultForm;
import systems.dennis.shared.ui_settings.model.FieldFormPosition;

import java.util.List;

;

@Data
public class UserFormSettingsForm implements DefaultForm {

    private String id;
    @OneToMany
    @ObjectByIdPresentation
    private List<FieldFormPosition> positions;
    private String entityType;

    @Override
    public String asValue() {
        return entityType + " " + id;
    }
}
