package systems.dennis.shared.ui_settings.controller;

import org.springframework.web.bind.annotation.*;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Id;
import systems.dennis.shared.annotations.security.SelfOnlyRole;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.mongo.controller.AddItemController;
import systems.dennis.shared.mongo.controller.DeleteItemController;
import systems.dennis.shared.mongo.controller.ListItemController;
import systems.dennis.shared.ui_settings.form.TableSettingForm;
import systems.dennis.shared.ui_settings.model.TableSettingModel;
import systems.dennis.shared.ui_settings.service.TableSettingService;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.security.DefaultIdChecker;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/v2/shared/table_setting")
@WebFormsSupport(value = TableSettingService.class)
@CrossOrigin
public class TableSettingController
        extends ApplicationContext
        implements AddItemController<TableSettingModel, TableSettingForm>,
        ListItemController<TableSettingModel, TableSettingForm>,
        systems.dennis.shared.mongo.controller.DeleteItemController<TableSettingModel> {

    public TableSettingController(WebContext context) {
        super(context);
    }

    @GetMapping("/list_all")
    @WithRole
    public List<TableSettingForm> findByUserAndTopic(@RequestParam(required = true) String topic) {
        return getService().findByUserAndTopic(topic).stream().map(this::toForm).collect(Collectors.toList());
    }


    @DeleteMapping(value = "/delete/{id}",  consumes = {"application/json", "application/json;charset=UTF-8"}, produces = {"application/json", "application/json;charset=UTF-8"})
    @ResponseBody
    @WithRole
    @SelfOnlyRole ()
    @Override
    public void delete(@Id(checker = DefaultIdChecker.class) @PathVariable String id) throws ItemForAddContainsIdException {
        DeleteItemController.super.delete(id);
    }

    @Override
    public TableSettingService getService() {
        return getBean(TableSettingService.class);
    }


}
