/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.ui_settings.service;

import java.util.Comparator;
import java.util.Optional;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.magic.UserSettingsFormInterface;
import systems.dennis.shared.ui_settings.model.FieldFormPosition;
import systems.dennis.shared.ui_settings.model.UserFormSettingsModel;
import systems.dennis.shared.ui_settings.service.UserFormSettingsService;
import systems.dennis.shared.utils.GeneratedPojoForm;
import systems.dennis.shared.utils.PojoFormField;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@Service
@Primary
public class UserSettingServiceEx
extends UserSettingsFormInterface {
    public void configForm(WebContext.LocalWebContext context, GeneratedPojoForm form, Class<?> formClass) {
        UserFormSettingsService bean = (UserFormSettingsService)((Object)context.getBean(UserFormSettingsService.class));
        try {
            Optional exists = bean.getRepository().filteredFirst(bean.createUserFormSpecification(formClass.getSimpleName()));
            if (exists.isPresent()) {
                GeneratedPojoForm changedForm = (GeneratedPojoForm)((BeanCopier)context.getBean(BeanCopier.class)).clone((Object)form);
                for (PojoFormField item : changedForm.getFieldList()) {
                    for (FieldFormPosition leftItem : ((UserFormSettingsModel)((Object)exists.get())).getPositions()) {
                        if (!item.getField().equalsIgnoreCase(leftItem.getFieldName())) continue;
                        item.setOrder(leftItem.getPosition());
                        item.setCustomName(leftItem.getTabName() == null ? item.getGroup() : leftItem.getTabName());
                    }
                }
                changedForm.getFieldList().sort(Comparator.comparing(PojoFormField::getOrder));
            }
        }
        catch (Exception e) {
            bean.getLogger().info("Cannot find saved form, ", (Throwable)e);
        }
    }
}

