/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.ui_settings.service;

import java.util.Optional;
import java.util.TimeZone;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.mongo.service.PaginationService;
import systems.dennis.shared.ui_settings.form.UserSettingForm;
import systems.dennis.shared.ui_settings.model.UserSettingModel;
import systems.dennis.shared.ui_settings.repository.UserSettingRepo;

@Service
@Primary
@DataRetrieverDescription(model=UserSettingModel.class, form=UserSettingForm.class, repo=UserSettingRepo.class)
public class UserSettingService
extends PaginationService<UserSettingModel> {
    public UserSettingService(WebContext holder) {
        super(holder);
    }

    public UserSettingModel preAdd(UserSettingModel object) throws ItemForAddContainsIdException {
        if (object.getId() == null) {
            UserSettingRepo repo = this.getRepository();
            Optional item = repo.filteredFirst(this.getFilterImpl().ofUser(UserSettingForm.class, this.getCurrentUser()));
            item.ifPresent(userSettingModel -> object.setId(userSettingModel.getId()));
        }
        return (UserSettingModel)super.preAdd((IDPresenter)object);
    }

    public UserSettingRepo getRepository() {
        return (UserSettingRepo)((Object)this.getBean(UserSettingRepo.class));
    }

    private UserSettingModel createNewSetting() {
        UserSettingModel model = new UserSettingModel();
        model.setTimeZone(TimeZone.getDefault());
        model.setLanguage("en");
        return (UserSettingModel)this.save((IDPresenter)model);
    }
}

