/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.ui_settings.service;

import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.mongo.service.PaginationService;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.ui_settings.form.UserFormSettingsForm;
import systems.dennis.shared.ui_settings.model.UserFormSettingsModel;
import systems.dennis.shared.ui_settings.repository.FieldFormPositionRepository;
import systems.dennis.shared.ui_settings.repository.UserFormSettingsRepo;

@Service
@DataRetrieverDescription(model=UserFormSettingsModel.class, form=UserFormSettingsForm.class, repo=UserFormSettingsRepo.class)
public class UserFormSettingsService<ID_TYPE extends Serializable>
extends PaginationService<UserFormSettingsModel> {
    private static final Logger log = LoggerFactory.getLogger(UserFormSettingsService.class);

    public UserFormSettingsService(WebContext holder) {
        super(holder);
    }

    public UserFormSettingsModel preAdd(UserFormSettingsModel object) throws ItemForAddContainsIdException {
        Optional existing = this.getRepository().filteredFirst(this.createUserFormSpecification(object.getEntityType()));
        FieldFormPositionRepository positionBean = (FieldFormPositionRepository)((Object)this.getBean(FieldFormPositionRepository.class));
        existing.ifPresent(userFormSettingsModel -> {
            object.setId(userFormSettingsModel.getId());
            try {
                positionBean.deleteAll(((UserFormSettingsModel)((Object)((Object)existing.get()))).getPositions());
            }
            catch (Exception e) {
                log.info("Cannot delete old items", (Throwable)e);
            }
        });
        positionBean.saveAll(object.getPositions());
        return (UserFormSettingsModel)super.preAdd((IDPresenter)object);
    }

    public UserFormSettingsRepo getRepository() {
        return (UserFormSettingsRepo)super.getRepository();
    }

    public AbstractDataFilter<UserFormSettingsModel> createUserFormSpecification(String entityType) {
        AbstractDataFilter specification = this.getSelfCreatedItems(((ISecurityUtils)this.getBean(ISecurityUtils.class)).getUserDataId(), false);
        AbstractDataFilter additionalSpecification = this.getFilterImpl().eq("entityType", (Object)entityType);
        return specification.and(additionalSpecification);
    }
}

