package systems.dennis.shared.ui_settings.service;

import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.mongo.service.PaginationService;
import systems.dennis.shared.ui_settings.form.UserSettingForm;
import systems.dennis.shared.ui_settings.model.UserSettingModel;
import systems.dennis.shared.ui_settings.repository.UserSettingRepo;

import java.util.TimeZone;

@Service
@Primary
@DataRetrieverDescription(model = UserSettingModel.class, form = UserSettingForm.class, repo = UserSettingRepo.class)
public class UserSettingService extends PaginationService<UserSettingModel> {
    public UserSettingService(WebContext holder) {
        super(holder);
    }

    @Override
    public UserSettingModel preAdd(UserSettingModel object) throws ItemForAddContainsIdException {

        if (object.getId() == null) {
            UserSettingRepo repo = getRepository();
            var item =   repo.filteredFirst(getFilterImpl().ofUser(UserSettingForm.class, getCurrentUser()));
            item.ifPresent(userSettingModel -> object.setId(userSettingModel.getId()));
        }
        return super.preAdd(object);
    }


    @Override
    public UserSettingRepo getRepository() {
        return getBean(UserSettingRepo.class);
    }

    private UserSettingModel createNewSetting() {
        UserSettingModel model = new UserSettingModel();
        model.setTimeZone(TimeZone.getDefault());
        model.setLanguage("en");
        return  save(model);
    }

}
