package systems.dennis.shared.ui_settings.model;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import lombok.Data;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.type.SqlTypes;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.converters.MagicQueryConverter;
import systems.dennis.shared.mongo.model.StringAssignableEntity;

import java.util.List;

import static systems.dennis.shared.annotations.DeleteStrategy.DELETE_STRATEGY_PROPERTY;

@Data
@Entity
@DeleteStrategy (value = DELETE_STRATEGY_PROPERTY, selfOnly = true)
public class TableSettingModel extends StringAssignableEntity {

    private String name;

    @Column(columnDefinition = "varchar(1500)")
    private String topic;

    @ElementCollection
    private List<String> fieldsOrder;
    @ElementCollection
    List<String> visibleFields;

    @Column(columnDefinition = "text")
    @JdbcTypeCode(SqlTypes.JSON)
    @Convert(converter = MagicQueryConverter.class)
    private MagicRequest magicQuery;

    private Boolean addToMenu;
    @Column(columnDefinition = "varchar(1500)")
    private String url;

    @Override
    public String asValue() {
        return name;
    }
}
