/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.servers.service;

import java.util.Objects;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.servers.exception.ServerException;
import systems.dennis.shared.servers.form.ServerConfigForm;
import systems.dennis.shared.servers.model.ServerConfig;
import systems.dennis.shared.servers.providers.ServerTypeProvider;
import systems.dennis.shared.servers.repository.ServerConfigRepo;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(repo=ServerConfigRepo.class, form=ServerConfigForm.class, model=ServerConfig.class)
public class ServerConfigService
extends PaginationService<ServerConfig> {
    public ServerConfigService(WebContext holder) {
        super(holder);
    }

    public void checkActiveTypeExists(ServerConfigForm element) {
        if (element.getActive() == null || !element.getActive().booleanValue()) {
            return;
        }
        if (Objects.equals(element.getType(), ServerTypeProvider.OTHER)) {
            return;
        }
        ServerConfigRepo repo = (ServerConfigRepo)this.getRepository();
        if (element.getId() == null ? repo.existsByTypeAndActiveIsTrue(element.getType()) : repo.existsByTypeAndActiveIsTrueAndIdNot(element.getType(), element.getId())) {
            throw new ServerException("Already_exists");
        }
    }

    public ServerConfig findByType(Long type, boolean silent) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"type", (Object)type).specification().addCase(QueryCase.equalsOf((String)"active", (Object)true));
        ServerConfig res = ((ServerConfigRepo)this.getBean(ServerConfigRepo.class)).findFirst((Specification)specification).orElse(null);
        if (silent && res == null) {
            return res;
        }
        if (res == null) {
            throw new ItemNotFoundException(type);
        }
        return res;
    }
}

