/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.servers.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.servers.form.ServerConfigForm;
import systems.dennis.shared.servers.model.ServerConfig;
import systems.dennis.shared.servers.service.ServerConfigService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/shared/servers"})
@Secured(roles={"ROLE_ADMIN"})
@CrossOrigin
@WebFormsSupport(value=ServerConfigService.class)
public class ServerController
extends ApplicationContext
implements Serviceable,
DeleteItemController,
AddItemController<ServerConfig, ServerConfigForm>,
EditItemController<ServerConfig, ServerConfigForm>,
ListItemController<ServerConfig, ServerConfigForm> {
    public ServerController(WebContext context) {
        super(context);
    }

    public ServerConfigService getService() {
        return (ServerConfigService)super.getService();
    }

    @WithRole(value="ROLE_SYNC")
    @GetMapping(value={"/type/{type}"})
    public ServerConfigForm findByType(@PathVariable(value="type") Long type) {
        return (ServerConfigForm)this.toForm(this.getService().findByType(type, false));
    }

    static {
        SearchEntityApi.registerSearch((String)"server", (SearcherInfo)new SearcherInfo("name", ServerConfigService.class));
    }
}

