/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.servers.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.postgres.service.PaginationService;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.servers.exception.ServerException;
import systems.dennis.shared.servers.form.ServerConfigForm;
import systems.dennis.shared.servers.model.ServerConfig;
import systems.dennis.shared.servers.providers.ServerTypeProvider;
import systems.dennis.shared.servers.repository.ServerConfigRepo;

@Service
@DataRetrieverDescription(repo=ServerConfigRepo.class, form=ServerConfigForm.class, model=ServerConfig.class)
public class ServerConfigService
extends PaginationService<ServerConfig> {
    private Map<Object, ServerConfig> serverConfigs = new HashMap<Object, ServerConfig>();

    public ServerConfigService(WebContext holder) {
        super(holder);
    }

    public void checkActiveTypeExists(ServerConfigForm element) {
        if (element.getActive() == null || !element.getActive().booleanValue()) {
            return;
        }
        if (Objects.equals(element.getType(), ServerTypeProvider.OTHER)) {
            return;
        }
        if (element.getId() == null ? this.count(this.getFilterImpl().eq("type", (Object)element.getType()).and(this.getFilterImpl().eq("active", (Object)true))) > 0L : this.count(this.getFilterImpl().eq("type", (Object)element.getType()).and(this.getFilterImpl().eq("active", (Object)true)).and(this.getFilterImpl().notEq("id", (Object)element.getId()))) > 0L) {
            throw new ServerException("server_already_exists");
        }
    }

    public ServerConfig afterAdd(ServerConfig object) {
        this.addToCache(object);
        return (ServerConfig)super.afterAdd((IDPresenter)object);
    }

    public void afterEdit(ServerConfig object, ServerConfig original) {
        this.addToCache(object);
        super.afterEdit((IDPresenter)object, (IDPresenter)original);
    }

    public ServerConfig afterDelete(ServerConfig object) {
        this.deleteFromCache(object);
        return (ServerConfig)super.afterDelete((IDPresenter)object);
    }

    public ServerConfig findByServerConfigTypeName(String serverConfigTypeName) {
        ServerConfig fromCache = this.getFromCache(serverConfigTypeName);
        if (fromCache != null) {
            return fromCache;
        }
        AbstractDataFilter filter = this.getFilterImpl().eq("name", (Object)serverConfigTypeName).setJoinOn("serverConfigType").and(this.getFilterImpl().eq("active", (Object)true));
        ServerConfig serverConfig = this.getRepository().filteredFirst(filter).orElse(null);
        if (serverConfig != null) {
            this.addToCache(serverConfig);
        }
        return serverConfig;
    }

    public ServerConfig findByType(Long type, boolean silent) {
        ServerConfig fromCache = this.getFromCache(type);
        if (fromCache != null) {
            return fromCache;
        }
        AbstractDataFilter filter = this.getFilterImpl().eq("type", (Object)type).and(this.getFilterImpl().eq("active", (Object)true));
        ServerConfig res = this.getRepository().filteredFirst(filter).orElse(null);
        if (silent && res == null) {
            return res;
        }
        if (res == null) {
            throw ItemNotFoundException.fromId((Serializable)type);
        }
        this.addToCache(res);
        return res;
    }

    private void addToCache(ServerConfig serverConfig) {
        Object key = this.getKey(serverConfig);
        if (serverConfig.getActive().booleanValue()) {
            this.serverConfigs.put(key, serverConfig);
        } else {
            this.serverConfigs.remove(key);
        }
    }

    private ServerConfig getFromCache(Object key) {
        return this.serverConfigs.get(key);
    }

    private void deleteFromCache(ServerConfig serverConfig) {
        Object key = this.getKey(serverConfig);
        this.serverConfigs.remove(key);
    }

    private Object getKey(ServerConfig serverConfig) {
        if (Objects.nonNull((Object)serverConfig.getServerConfigType())) {
            return serverConfig.getServerConfigType().getName();
        }
        return serverConfig.getType();
    }
}

