package systems.dennis.shared.servers.form;

import lombok.Data;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.validation.FieldIsUniqueValidator;
import systems.dennis.shared.validation.ValueNotEmptyValidator;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.HIDDEN;
import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.TEXT;

@Data
@PojoListView(actions = {"download",  "new", "settings"})
public class ServerConfigTypeForm implements DefaultForm {

    @PojoFormElement (type = HIDDEN)
    private Long id;

    @PojoFormElement (type = TEXT)
    @Validation (value = {ValueNotEmptyValidator.class, FieldIsUniqueValidator.class})
    private String name;


    @PojoListViewField(showContent = false, actions = {
            @UIAction(component = "edit"), @UIAction(component = "delete", allowOnMultipleRows = true)
    })

    @PojoFormElement(type = HIDDEN)
    private Long actions;
}
