package systems.dennis.shared.servers.form;

import lombok.Data;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.pojo_form.Checkable;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.servers.controller.ServerTypeController;
import systems.dennis.shared.servers.model.ServerConfigType;
import systems.dennis.shared.servers.providers.ServerTypeProvider;
import systems.dennis.shared.servers.service.ServerConfigTypeService;
import systems.dennis.shared.servers.validation.ServerTypeValidator;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;
import systems.dennis.shared.validation.ValueIsIntAndMoreThenZero;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.*;

@Data
@PojoListView (actions = {"download",  "new", "settings"})
public class ServerConfigForm implements DefaultForm {

    @PojoFormElement(type = HIDDEN)
    private Long id;

    @PojoFormElement(required = true)
    @PojoListViewField (searchable = true)
    private String name;

    @PojoFormElement(required = true)
    @PojoListViewField (searchable = true)
    private String host;

    @PojoListViewField (searchable = true)
    @PojoFormElement (type =  "number")
    @Validation (ValueIsIntAndMoreThenZero.class)
    private Integer port;

    @PojoListViewField (searchable = true)

    @PojoFormElement
    private String userName;

    @PojoFormElement(type = PASSWORD)
    @PojoListViewField(available = false)
    private String password;

    @PojoListViewField (searchable = true)
    private String serverParam;

    @PojoListViewField (searchable = true)
    @PojoFormElement
    private String timeZone;

    @PojoFormElement (remote = @Remote(controller = ServerTypeController.class), type = OBJECT_SEARCH)
    @PojoListViewField(remote = @Remote(controller = ServerTypeController.class), type = OBJECT_SEARCH)
    @ObjectByIdPresentation
    @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = ServerConfigTypeService.class)
    private Long serverConfigType;

    @PojoFormElement(type = DROP_DOWN, dataProvider = ServerTypeProvider.class)
    private Long type;

    @PojoFormElement(type = CHECKBOX, checked = @Checkable(checked = true), remote = @Remote(searchType = "CHECKBOX"))
    private Boolean active;

    @PojoListViewField(showContent = false, actions = {
            @UIAction(component = "edit"), @UIAction(component = "delete", allowOnMultipleRows = true)
    })

    @PojoFormElement(type = HIDDEN)
    private Long actions;

    @Override
    public String asValue() {
        return name  + " " + type;
    }
}
