/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.servers.service;

import java.io.Serializable;
import java.util.Objects;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.postgres.service.PaginationService;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.servers.exception.ServerException;
import systems.dennis.shared.servers.form.ServerConfigForm;
import systems.dennis.shared.servers.model.ServerConfig;
import systems.dennis.shared.servers.providers.ServerTypeProvider;
import systems.dennis.shared.servers.repository.ServerConfigRepo;

@Service
@DataRetrieverDescription(repo=ServerConfigRepo.class, form=ServerConfigForm.class, model=ServerConfig.class)
public class ServerConfigService
extends PaginationService<ServerConfig> {
    public ServerConfigService(WebContext holder) {
        super(holder);
    }

    public void checkActiveTypeExists(ServerConfigForm element) {
        if (element.getActive() == null || !element.getActive().booleanValue()) {
            return;
        }
        if (Objects.equals(element.getType(), ServerTypeProvider.OTHER)) {
            return;
        }
        if (element.getId() == null ? this.count(this.getFilterImpl().eq("type", (Object)element.getType()).and(this.getFilterImpl().eq("active", (Object)true))) > 0L : this.count(this.getFilterImpl().eq("type", (Object)element.getType()).and(this.getFilterImpl().eq("active", (Object)true)).and(this.getFilterImpl().notEq("id", (Object)element.getId()))) > 0L) {
            throw new ServerException("server_already_exists");
        }
    }

    public ServerConfig findByServerConfigTypeName(String serverConfigTypeName) {
        AbstractDataFilter filter = this.getFilterImpl().eq("name", (Object)serverConfigTypeName).setJoinOn("serverConfigType").and(this.getFilterImpl().eq("active", (Object)true));
        return this.getRepository().filteredFirst(filter).orElse(null);
    }

    public ServerConfig findByType(Long type, boolean silent) {
        AbstractDataFilter filter = this.getFilterImpl().eq("type", (Object)type).and(this.getFilterImpl().eq("active", (Object)true));
        ServerConfig res = this.getRepository().filteredFirst(filter).orElse(null);
        if (silent && res == null) {
            return res;
        }
        if (res == null) {
            throw ItemNotFoundException.fromId((Serializable)type);
        }
        return res;
    }
}

