/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.servers.beans;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import systems.dennis.shared.annotations.NeverNullResponse;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.servers.model.ServerConfig;
import systems.dennis.shared.servers.service.ServerConfigService;
import systems.dennis.shared.utils.Mapper;
import systems.dennis.shared.utils.Supplier;

public class ServerRequest<T> {
    private static final Logger log = LoggerFactory.getLogger(ServerRequest.class);
    private RestTemplate restTemplate;
    private WebContext context;
    private Map<Integer, Supplier<?>> onError = new HashMap();
    private T result;
    private String url;
    public static String AUTH_TYPE_HEADER = "AUTH_TYPE";
    public static String AUTH_SCOPE_HEADER = "AUTH_SCOPE";
    public static final String AUTH_TYPE_DEFAULT = "DEFAULT";
    public static String AUTH_TYPE_VIRTUAL = "VIRTUAL";
    private final HttpHeaders headers = new HttpHeaders();
    private ServerConfig server;

    public ServerRequest(RestTemplate restTemplate, WebContext context) {
        this.restTemplate = restTemplate;
        this.context = context;
    }

    @NeverNullResponse
    public ServerRequest<T> virtualAuth() {
        this.headers.set(AUTH_TYPE_HEADER, AUTH_TYPE_VIRTUAL);
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> uri(String uri) {
        this.url = uri;
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> server(Long type) {
        this.server = ((ServerConfigService)((Object)this.context.getBean(ServerConfigService.class))).findByType(type, true);
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> server(ServerConfig server) {
        this.server = (ServerConfig)((ServerConfigService)((Object)this.context.getBean(ServerConfigService.class))).findByIdOrThrow(server.getId());
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> token(String token) {
        this.headers.setBearerAuth(token);
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> scope() {
        this.headers.set(AUTH_SCOPE_HEADER, this.getCurrentScope());
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> header(Map<String, String> headerMap) {
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            this.headers.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> contentType(MediaType contentType) {
        this.headers.setContentType(contentType);
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> onErrorStatusError(int status, Supplier<?> e) {
        this.onError.put(status, e);
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> onAnyErrorStatusError(Supplier<?> e) {
        this.onError.put(-1, e);
        return this;
    }

    @Deprecated
    @NeverNullResponse
    public ServerRequest<T> defaultAuthType() {
        this.headers.set(AUTH_TYPE_HEADER, AUTH_TYPE_DEFAULT);
        return this;
    }

    public <E> T executePost(E object, Class<T> tClass) {
        try {
            if (!this.headers.containsKey((Object)"Content-Type")) {
                this.headers.setContentType(MediaType.APPLICATION_JSON);
            }
            HttpEntity el = new HttpEntity(object, (MultiValueMap)this.headers);
            ResponseEntity resp = this.restTemplate.postForEntity(this.server.getRoot() + this.url, (Object)el, tClass, new Object[0]);
            this.validateExceptions(resp);
            this.result = resp.getBody();
            return this.result;
        }
        catch (Exception e) {
            this.printRequest(e);
            throw e;
        }
    }

    public <E> T executePut(E object, Class<T> tClass) {
        if (!this.headers.containsKey((Object)"Content-Type")) {
            this.headers.setContentType(MediaType.APPLICATION_JSON);
        }
        HttpEntity entity = new HttpEntity(object, (MultiValueMap)this.headers);
        ResponseEntity response = this.restTemplate.exchange(this.server.getRoot() + this.url, HttpMethod.PUT, entity, tClass, new Object[0]);
        this.validateExceptions(response);
        this.result = response.getBody();
        return this.result;
    }

    public <E> T executePatch(E object, Class<T> tClass) {
        if (!this.headers.containsKey((Object)"Content-Type")) {
            this.headers.setContentType(MediaType.APPLICATION_JSON);
        }
        HttpEntity entity = new HttpEntity(object, (MultiValueMap)this.headers);
        ResponseEntity response = this.restTemplate.exchange(this.server.getRoot() + this.url, HttpMethod.PATCH, entity, tClass, new Object[0]);
        this.validateExceptions(response);
        this.result = response.getBody();
        return this.result;
    }

    private void validateExceptions(ResponseEntity<T> resp) {
        this.printResponse(resp);
        Supplier<?> anyError = this.onError.get(-1);
        if (200 != resp.getStatusCode().value()) {
            this.onError.keySet().forEach(code -> {
                if (code != -1 && resp.getStatusCode().value() == code.intValue()) {
                    this.onError.get(code).onNull((Object)resp.getStatusCode().value());
                }
            });
            if (anyError != null) {
                anyError.onNull((Object)resp.getStatusCode().value());
            }
        }
    }

    private void printResponse(ResponseEntity<T> resp) {
        log.debug("Url: " + this.url);
        log.debug("code: " + String.valueOf(resp.getStatusCode()));
        if (resp.getBody() != null) {
            try {
                log.debug("message: " + Mapper.mapper.writeValueAsString(resp.getBody()));
            }
            catch (Exception e) {
                log.debug("message: " + String.valueOf(resp.getBody()));
            }
        } else {
            log.debug("message: null");
        }
    }

    private void printRequest(Exception e) {
        log.error("Url: " + this.url);
        log.error("exception", (Throwable)e);
    }

    public <E> T executeGet(Class<T> tClass) {
        try {
            HttpEntity el = new HttpEntity((MultiValueMap)this.headers);
            ResponseEntity resp = this.restTemplate.exchange(this.server.getRoot() + this.url, HttpMethod.GET, el, tClass, new Object[0]);
            this.validateExceptions(resp);
            this.result = resp.getBody();
            return this.result;
        }
        catch (Exception e) {
            this.printRequest(e);
            throw e;
        }
    }

    public <E> T executeGet(ParameterizedTypeReference<T> respType) {
        try {
            HttpEntity el = new HttpEntity((MultiValueMap)this.headers);
            ResponseEntity resp = this.restTemplate.exchange(this.server.getRoot() + this.url, HttpMethod.GET, el, respType, new Object[0]);
            this.validateExceptions(resp);
            this.result = resp.getBody();
            return this.result;
        }
        catch (Exception e) {
            this.printRequest(e);
            throw e;
        }
    }

    public void executeDelete(Class<T> tClass) {
        try {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.headers);
            ResponseEntity resp = this.restTemplate.exchange(this.server.getRoot() + this.url, HttpMethod.DELETE, requestEntity, tClass, new Object[0]);
            this.validateExceptions(resp);
        }
        catch (Exception e) {
            this.printRequest(e);
            throw e;
        }
    }

    private String getCurrentScope() {
        return (String)this.context.getEnv("dennis.systems.security.scope.id", (Object)"Default");
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public WebContext getContext() {
        return this.context;
    }

    public Map<Integer, Supplier<?>> getOnError() {
        return this.onError;
    }

    public T getResult() {
        return this.result;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }
}

