package systems.dennis.shared.servers.validation;

import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.config.WebContext;

import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.servers.form.ServerConfigForm;
import systems.dennis.shared.servers.service.ServerConfigService;
import systems.dennis.shared.validation.ValueValidator;

public class ServerTypeValidator implements ValueValidator<ServerConfigForm, Long> {
    @Override
    public ValidationResult validate(ServerConfigForm element,Long value, ValidationContent content) {

        try {
            content.getContext().getBean(ServerConfigService.class).checkActiveTypeExists(element);
        } catch (Exception e){
            return ValidationResult.fail("server.type.already_active");
        }

        return ValidationResult.PASSED;
    }
}
