/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.servers.form;

import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.pojo_form.Checkable;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.servers.providers.ServerTypeProvider;
import systems.dennis.shared.servers.validation.ServerTypeValidator;
import systems.dennis.shared.validation.ValueIsIntAndMoreThenZero;

@PojoListView(actions={"download", "new", "settings"})
public class ServerConfigForm
implements DefaultForm {
    @PojoFormElement(type="hidden")
    private Long id;
    @PojoFormElement(required=true)
    @PojoListViewField(searchable=true)
    private String name;
    @PojoFormElement(required=true)
    @PojoListViewField(searchable=true)
    private String host;
    @PojoListViewField(searchable=true)
    @PojoFormElement(type="number")
    @Validation(value={ValueIsIntAndMoreThenZero.class})
    private Integer port;
    @PojoListViewField(searchable=true)
    @PojoFormElement
    private String userName;
    @PojoFormElement(type="password")
    @PojoListViewField(available=false)
    private String password;
    @PojoListViewField(searchable=true)
    private String serverParam;
    @PojoListViewField(searchable=true)
    @PojoFormElement
    private String timeZone;
    @PojoFormElement(type="drop-down", dataProvider=ServerTypeProvider.class, validators={ServerTypeValidator.class})
    private Long type;
    @PojoFormElement(type="checkbox", checked=@Checkable(checked=true), remote=@Remote(searchType="CHECKBOX"))
    private Boolean active;
    @PojoListViewField(showContent=false, actions={@UIAction(component="edit"), @UIAction(component="delete", allowOnMultipleRows=true)})
    @PojoFormElement(type="hidden")
    private Long actions;

    public String asValue() {
        return this.name + " " + this.type;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServerParam() {
        return this.serverParam;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Long getType() {
        return this.type;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Long getActions() {
        return this.actions;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setServerParam(String serverParam) {
        this.serverParam = serverParam;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setActions(Long actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerConfigForm)) {
            return false;
        }
        ServerConfigForm other = (ServerConfigForm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Long this$type = this.getType();
        Long other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$actions = this.getActions();
        Long other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$serverParam = this.getServerParam();
        String other$serverParam = other.getServerParam();
        if (this$serverParam == null ? other$serverParam != null : !this$serverParam.equals(other$serverParam)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        return !(this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerConfigForm;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Long $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $serverParam = this.getServerParam();
        result = result * 59 + ($serverParam == null ? 43 : $serverParam.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        return result;
    }

    public String toString() {
        return "ServerConfigForm(id=" + this.getId() + ", name=" + this.getName() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", serverParam=" + this.getServerParam() + ", timeZone=" + this.getTimeZone() + ", type=" + this.getType() + ", active=" + this.getActive() + ", actions=" + this.getActions() + ")";
    }
}

