/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.servers.controller;

import java.io.Serializable;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.postgres.controller.AddItemController;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.postgres.controller.EditItemController;
import systems.dennis.shared.postgres.controller.ListItemController;
import systems.dennis.shared.servers.form.ServerConfigForm;
import systems.dennis.shared.servers.model.ServerConfig;
import systems.dennis.shared.servers.service.ServerConfigService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/shared/servers"})
@Secured(roles={"ROLE_ADMIN"})
@CrossOrigin
@WebFormsSupport(value=ServerConfigService.class)
public class ServerController<TYPE_ID extends Serializable>
extends ApplicationContext
implements DeleteItemController<ServerConfig>,
AddItemController<ServerConfig, ServerConfigForm>,
EditItemController<ServerConfig, ServerConfigForm>,
ListItemController<ServerConfig, ServerConfigForm> {
    public ServerController(WebContext context) {
        super(context);
    }

    public ServerConfigService getService() {
        return (ServerConfigService)super.getService();
    }

    @WithRole(value="ROLE_SYNC")
    @GetMapping(value={"/type/{type}"})
    public ServerConfigForm findByType(@PathVariable(value="type") Long type) {
        return (ServerConfigForm)this.toForm((AbstractEntity)this.getService().findByType(type, false));
    }

    static {
        SearchEntityApi.registerSearch((String)"server", (SearcherInfo)new SearcherInfo("name", ServerConfigService.class));
    }
}

