package systems.dennis.shared.servers.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import lombok.Data;
import systems.dennis.shared.postgres.model.BaseEntity;

@Entity
@Data
public class ServerConfig  extends BaseEntity {
    private String host;
    private String name;
    private String userName;
    private String password;
    private Integer port;
    private Long type;
    private Boolean active;
    private String serverParam;
    private String timeZone;

    @Transient
    public String getRoot(){
        return host + ":" + port + "/";
    }

    @Override
    public String asValue() {
        return getRoot();
    }
}
