package systems.dennis.shared.servers.service;

import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.mongo.service.PaginationService;
import systems.dennis.shared.mongo.service.StringIdEntity;
import systems.dennis.shared.servers.exception.ServerException;
import systems.dennis.shared.servers.form.ServerConfigForm;
import systems.dennis.shared.servers.form.ServerConfigTypeForm;
import systems.dennis.shared.servers.model.ServerConfig;
import systems.dennis.shared.servers.model.ServerConfigType;
import systems.dennis.shared.servers.providers.ServerTypeProvider;
import systems.dennis.shared.servers.repository.ServerConfigRepo;
import systems.dennis.shared.servers.repository.ServerConfigTypeRepo;

import java.util.Objects;

@Service
@DataRetrieverDescription(repo = ServerConfigTypeRepo.class, form = ServerConfigTypeForm.class, model = ServerConfigType.class)
public class ServerConfigTypeService extends PaginationService<ServerConfigType> {
    public ServerConfigTypeService(WebContext holder) {
        super(holder);
    }

}
