package systems.dennis.shared.servers.model;

import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Transient;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.mongo.service.StringIdEntity;
import systems.dennis.shared.servers.service.ServerConfigTypeService;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Document
@Data
public class ServerConfig  extends StringIdEntity  {
    private String host;
    private String name;
    private String userName;
    private String password;
    private Integer port;
    private Long type;
    private Boolean active;
    private String serverParam;
    private String timeZone;

    @DBRef
    @ObjectByIdPresentation
    @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = ServerConfigTypeService.class)
    private ServerConfigType serverConfigType;

    @Transient
    public String getRoot(){
        return host + ":" + port + "/";
    }

    @Override
    public String asValue() {
        return getRoot();
    }
}
