package systems.dennis.shared.servers.controller;

import org.springframework.web.bind.annotation.*;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;

import systems.dennis.shared.mongo.controller.AddItemController;
import systems.dennis.shared.mongo.controller.DeleteItemController;
import systems.dennis.shared.mongo.controller.EditItemController;
import systems.dennis.shared.mongo.controller.ListItemController;
import systems.dennis.shared.servers.form.ServerConfigForm;
import systems.dennis.shared.servers.model.ServerConfig;
import systems.dennis.shared.servers.service.ServerConfigService;
import systems.dennis.shared.utils.ApplicationContext;

/**
 * Provides Role adding, editing, deleting and assigning
 */
@RestController
@RequestMapping("/api/v2/shared/servers")
@Secured (roles = "ROLE_ADMIN")
@CrossOrigin
@WebFormsSupport(ServerConfigService.class)
public class ServerController extends ApplicationContext implements
        DeleteItemController<ServerConfig>,
        AddItemController<ServerConfig, ServerConfigForm>,
        EditItemController<ServerConfig, ServerConfigForm>,
        ListItemController<ServerConfig, ServerConfigForm> {

    static  {
        SearchEntityApi.registerSearch("server", new SearcherInfo("name", ServerConfigService.class));
    }

    public ServerController(WebContext context) {
        super(context );
    }

    @Override
    public ServerConfigService getService() {
        return (ServerConfigService) getContext().getBean(getServiceClass());
    }

    @WithRole("ROLE_SYNC")
    @GetMapping("/type/{type}")
    public ServerConfigForm findByType(@PathVariable("type") Long type) {


        return toForm(getService().findByType(type, false));
    }
}
