/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.servers.beans;

import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import systems.dennis.shared.annotations.NeverNullResponse;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.servers.model.ServerConfig;
import systems.dennis.shared.servers.service.ServerConfigService;
import systems.dennis.shared.utils.Supplier;

public class ServerRequest<T> {
    private RestTemplate restTemplate;
    private WebContext context;
    private Map<Integer, Supplier<?>> onError = new HashMap();
    private T result;
    private String url;
    public static String AUTH_TYPE_HEADER = "AUTH_TYPE";
    public static String AUTH_SCOPE_HEADER = "AUTH_SCOPE";
    public static final String AUTH_TYPE_DEFAULT = "DEFAULT";
    public static String AUTH_TYPE_VIRTUAL = "VIRTUAL";
    private final HttpHeaders headers = new HttpHeaders();
    private ServerConfig server;

    public ServerRequest(RestTemplate restTemplate, WebContext context) {
        this.restTemplate = restTemplate;
        this.context = context;
    }

    @NeverNullResponse
    public ServerRequest<T> virtualAuth() {
        this.headers.set(AUTH_TYPE_HEADER, AUTH_TYPE_VIRTUAL);
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> uri(String uri) {
        this.url = uri;
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> server(Long type) {
        this.server = ((ServerConfigService)((Object)this.context.getBean(ServerConfigService.class))).findByType(type, true);
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> token(String token) {
        this.headers.setBearerAuth(token);
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> scope() {
        this.headers.set(AUTH_SCOPE_HEADER, this.getCurrentScope());
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> onErrorStatusError(int status, Supplier<?> e) {
        this.onError.put(status, e);
        return this;
    }

    @NeverNullResponse
    public ServerRequest<T> onAnyErrorStatusError(Supplier<?> e) {
        this.onError.put(-1, e);
        return this;
    }

    @Deprecated
    @NeverNullResponse
    public ServerRequest<T> defaultAuthType() {
        this.headers.set(AUTH_TYPE_HEADER, AUTH_TYPE_DEFAULT);
        return this;
    }

    public <E> T executePost(E object, Class<T> tClass) {
        HttpEntity el = new HttpEntity(object, (MultiValueMap)this.headers);
        ResponseEntity resp = this.restTemplate.postForEntity(this.server.getRoot() + this.url, (Object)el, tClass, new Object[0]);
        this.validateExceptions(resp);
        this.result = resp.getBody();
        return this.result;
    }

    private void validateExceptions(ResponseEntity<T> resp) {
        Supplier<?> anyError = this.onError.get(-1);
        if (200 != resp.getStatusCode().value()) {
            this.onError.keySet().forEach(code -> {
                if (code != -1 && resp.getStatusCode().value() == code.intValue()) {
                    this.onError.get(code).onNull((Object)resp.getStatusCode().value());
                }
            });
            if (anyError != null) {
                anyError.onNull((Object)resp.getStatusCode().value());
            }
        }
    }

    public <E> T executeGet(Class<T> tClass) {
        HttpEntity el = new HttpEntity((MultiValueMap)this.headers);
        ResponseEntity resp = this.restTemplate.exchange(this.server.getRoot() + this.url, HttpMethod.GET, el, tClass, new Object[0]);
        this.validateExceptions(resp);
        this.result = resp.getBody();
        return this.result;
    }

    public void executeDelete(Class<T> tClass) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.headers);
        ResponseEntity resp = this.restTemplate.exchange(this.server.getRoot() + this.url, HttpMethod.DELETE, requestEntity, tClass, new Object[0]);
        this.validateExceptions(resp);
    }

    private String getCurrentScope() {
        return (String)this.context.getEnv("dennis.systems.security.scope.id", (Object)"Default");
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public WebContext getContext() {
        return this.context;
    }

    public Map<Integer, Supplier<?>> getOnError() {
        return this.onError;
    }

    public T getResult() {
        return this.result;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }
}

