/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.scopes.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import java.util.Date;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.scopes.model.ScopeRuleModel;
import systems.dennis.shared.scopes.service.ScopeRuleService;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class ScopeModel
extends UserAssignableEntity {
    private String name;
    @Column(columnDefinition="text")
    private String description;
    @FormTransient
    private String secretKey;
    private Boolean blocked = Boolean.FALSE;
    @FormTransient
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    private Date date;
    @Column(columnDefinition="varchar(1000)")
    private String url;
    private String verificationUrl;
    @ManyToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ScopeRuleService.class)
    private ScopeRuleModel scopeRule;

    public String asValue() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public Boolean getBlocked() {
        return this.blocked;
    }

    public Date getDate() {
        return this.date;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVerificationUrl() {
        return this.verificationUrl;
    }

    public ScopeRuleModel getScopeRule() {
        return this.scopeRule;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setBlocked(Boolean blocked) {
        this.blocked = blocked;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setVerificationUrl(String verificationUrl) {
        this.verificationUrl = verificationUrl;
    }

    public void setScopeRule(ScopeRuleModel scopeRule) {
        this.scopeRule = scopeRule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScopeModel)) {
            return false;
        }
        ScopeModel other = (ScopeModel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$blocked = this.getBlocked();
        Boolean other$blocked = other.getBlocked();
        if (this$blocked == null ? other$blocked != null : !((Object)this$blocked).equals(other$blocked)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$verificationUrl = this.getVerificationUrl();
        String other$verificationUrl = other.getVerificationUrl();
        if (this$verificationUrl == null ? other$verificationUrl != null : !this$verificationUrl.equals(other$verificationUrl)) {
            return false;
        }
        ScopeRuleModel this$scopeRule = this.getScopeRule();
        ScopeRuleModel other$scopeRule = other.getScopeRule();
        return !(this$scopeRule == null ? other$scopeRule != null : !((Object)((Object)this$scopeRule)).equals((Object)other$scopeRule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScopeModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $blocked = this.getBlocked();
        result = result * 59 + ($blocked == null ? 43 : ((Object)$blocked).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $verificationUrl = this.getVerificationUrl();
        result = result * 59 + ($verificationUrl == null ? 43 : $verificationUrl.hashCode());
        ScopeRuleModel $scopeRule = this.getScopeRule();
        result = result * 59 + ($scopeRule == null ? 43 : ((Object)((Object)$scopeRule)).hashCode());
        return result;
    }

    public String toString() {
        return "ScopeModel(name=" + this.getName() + ", description=" + this.getDescription() + ", secretKey=" + this.getSecretKey() + ", blocked=" + this.getBlocked() + ", date=" + String.valueOf(this.getDate()) + ", url=" + this.getUrl() + ", verificationUrl=" + this.getVerificationUrl() + ", scopeRule=" + String.valueOf((Object)this.getScopeRule()) + ")";
    }
}

