/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.scopes.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.scopes.form.ScopeForm;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.scopes.service.ScopeService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/shared/scope"})
@WebFormsSupport(value=ScopeService.class)
@CrossOrigin
public class ScopeController
extends ApplicationContext
implements AddItemController<ScopeModel, ScopeForm>,
EditItemController<ScopeModel, ScopeForm>,
ListItemController<ScopeModel, ScopeForm>,
DeleteItemController {
    public ScopeController(WebContext context) {
        super(context);
    }

    @WithRole(value="ROLE_ADMIN")
    public ResponseEntity<ScopeForm> edit(ScopeForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return super.edit((DefaultForm)form);
    }

    @WithRole(value="ROLE_ADMIN")
    public void delete(Long id) throws ItemNotUserException, ItemNotFoundException {
        super.delete(id);
    }

    public ScopeService getService() {
        return (ScopeService)super.getService();
    }

    static {
        SearchEntityApi.registerSearch((String)"scope", (SearcherInfo)new SearcherInfo("name", ScopeService.class));
    }
}

