package systems.dennis.shared.scopes.service;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;

import systems.dennis.shared.scopes.form.ScopeForm;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.repository.QueryCase;

import systems.dennis.shared.scopes.repository.ScopeRepo;
import systems.dennis.shared.service.PaginationService;

import java.util.Date;
import java.util.Objects;

@Service
@DataRetrieverDescription(model = ScopeModel.class, form = ScopeForm.class, repo = ScopeRepo.class)
@DeleteStrategy(value = BaseEntity.DELETE_STRATEGY_PROPERTY)
public class ScopeService extends PaginationService<ScopeModel> {

    public ScopeService(WebContext holder) {
        super(holder);
    }

    @Override
    public ScopeModel preAdd(ScopeModel object) throws ItemForAddContainsIdException {
        object.setDate(new Date());

        return super.preAdd(object);
    }

    public ScopeModel findByName(String name, Long userData, boolean fullAccess) {
        if (name == null){
            throw new ItemNotFoundException("global.scope.cannot_be_null_in_request");
        }
        Specification<ScopeModel> specification = QueryCase.equalsOf("name", name).specification()
                .addCase(getNotDeletedQuery());

        if (!fullAccess && Objects.nonNull(addSelfSpecWithUserScopes(userData))) {
            specification = specification.and(addSelfSpecWithUserScopes(userData));
        }

        return getRepository().findOne(specification).orElseThrow(()-> new ItemNotFoundException(name));
    }

    public Specification<ScopeModel> addSelfSpecWithUserScopes(Long userData) {
        return null;
    }
}
