package systems.dennis.shared.scopes.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.EditItemController;
import systems.dennis.shared.controller.items.ListSelfItemsController;
import systems.dennis.shared.scopes.form.ScopeRuleForm;
import systems.dennis.shared.scopes.model.ScopeRuleModel;
import systems.dennis.shared.scopes.service.ScopeRuleService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping("/api/v2/shared/scope_rule")
@WebFormsSupport(value = ScopeRuleService.class)
@CrossOrigin
public class ScopeRuleController extends ApplicationContext
        implements AddItemController<ScopeRuleModel, ScopeRuleForm>,
        EditItemController<ScopeRuleModel, ScopeRuleForm>,
        ListSelfItemsController<ScopeRuleModel, ScopeRuleForm>,
        DeleteItemController {

    static  {
        SearchEntityApi.registerSearch("scope_rule", new SearcherInfo("name", ScopeRuleService.class));
    }

    public ScopeRuleController(WebContext context) {
        super(context);
    }
}
