/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.scopes.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.postgres.controller.AddItemController;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.postgres.controller.EditItemController;
import systems.dennis.shared.postgres.controller.SelfItemsListController;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.scopes.form.ScopeForm;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.scopes.service.ScopeService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/shared/scope"})
@WebFormsSupport(value=ScopeService.class)
@CrossOrigin
@Secured(roles={"ROLE_ADMIN"})
public class ScopeController
extends ApplicationContext
implements AddItemController<ScopeModel, ScopeForm>,
EditItemController<ScopeModel, ScopeForm>,
SelfItemsListController<ScopeModel, ScopeForm>,
DeleteItemController<ScopeModel> {
    public ScopeController(WebContext context) {
        super(context);
    }

    @WithRole(value="ROLE_ADMIN")
    public ResponseEntity<ScopeForm> edit(ScopeForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return super.edit((DefaultForm)form);
    }

    public ScopeService getService() {
        return (ScopeService)super.getService();
    }

    static {
        SearchEntityApi.registerSearch((String)"scope", (SearcherInfo)new SearcherInfo("name", ScopeService.class));
    }
}

