package systems.dennis.shared.scopes.service;

import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.postgres.service.PaginationService;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.scopes.form.ScopeForm;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.scopes.repository.ScopeRepo;

import java.util.Date;
import java.util.Objects;

import static systems.dennis.shared.annotations.DeleteStrategy.DELETE_STRATEGY_PROPERTY;

@Service
@DataRetrieverDescription(model = ScopeModel.class, form = ScopeForm.class, repo = ScopeRepo.class)
@DeleteStrategy(value =  DELETE_STRATEGY_PROPERTY)
public class ScopeService extends PaginationService<ScopeModel > {

    public ScopeService(WebContext holder) {
        super(holder);
    }

    @Override
    public ScopeModel preAdd(ScopeModel object) throws ItemForAddContainsIdException {
        object.setDate(new Date());

        return super.preAdd(object);
    }

    public ScopeModel findByName(String name, Long userData, boolean fullAccess) {
        if (name == null){
            throw new ItemNotFoundException("global.scope.cannot_be_null_in_request");
        }

        var filter = getFilterImpl().eq("name", name).and(getNotDeletedQuery());

        if (!fullAccess && Objects.nonNull(addSelfSpecWithUserScopes(userData))) {
            filter.and(addSelfSpecWithUserScopes(userData));
        }

        return getRepository().filteredOne(filter).orElseThrow(()-> new ItemNotFoundException(name));
    }

    public AbstractDataFilter<ScopeModel> addSelfSpecWithUserScopes(Long userData) {
        return null;
    }
}
