package systems.dennis.shared.scopes.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import lombok.Data;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.annotations.entity.Created;
import systems.dennis.shared.postgres.model.LongAssignableEntity;
import systems.dennis.shared.scopes.service.ScopeRuleService;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.DateToUTCConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

import java.util.Date;

@Entity
@Data
public class ScopeModel  extends LongAssignableEntity {

    private String name;

    @Column(columnDefinition = "text")
    private String description;

    @FormTransient
    private String secretKey;

    private Boolean blocked = Boolean.FALSE;

    @FormTransient
    @DataTransformer(transFormWith  = DateToUTCConverter.class)
    @Created
    private Date date;

    @Column(columnDefinition = "varchar(1000)")
    private String url;

    private String verificationUrl;

    @ManyToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = ScopeRuleService.class)
    private ScopeRuleModel scopeRule;

    @Override
    public String asValue() {
        return name;
    }
}
