package systems.dennis.shared.scopes.form;

import lombok.Data;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.DEFAULT_TYPES;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.scopes.service.ScopeRuleService;
import systems.dennis.shared.utils.TSDate;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.DateToUTCConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;
import systems.dennis.shared.validation.FieldIsUniqueValidator;
import systems.dennis.shared.validation.ValueNotEmptyValidator;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.*;

@Data
@PojoListView(actions = {UIAction.ACTION_DOWNLOAD, UIAction.ACTION_NEW, UIAction.ACTION_SETTINGS})
public class ScopeForm implements DefaultForm {
    @PojoFormElement(type = HIDDEN)
    private Long id;

    @PojoFormElement
    @PojoListViewField(searchable = true)
    @Validation({ValueNotEmptyValidator.class, FieldIsUniqueValidator.class})
    private String name;

    @PojoFormElement (required = true, type =  TEXT_AREA)
    @PojoListViewField(searchable = true)
    private String description;

    @PojoFormElement(type = DATE, available = false)
    @PojoListViewField(searchable = true, type = DATE, format =  DATE_FORMAT_FULL,  remote = @Remote(searchType = DATE_TIME))
    @DataTransformer(transFormWith = DateToUTCConverter.class)
    private TSDate date;

    @PojoFormElement (type = HIDDEN)
    @PojoListViewField (type = TEXT, visible = false)
    private String secretKey;
    @PojoFormElement
    @PojoListViewField(searchable = true)
    private String url;

    @PojoFormElement
    @PojoListViewField(searchable = true)
    private String verificationUrl;

    @ObjectByIdPresentation
    @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = ScopeRuleService.class)
    @PojoFormElement( type = DEFAULT_TYPES.OBJECT_SEARCH,
            remote = @Remote(fetcher = "shared/scope_rule", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchField = "name", searchName = "scope_rule"))
    @PojoListViewField(type = DEFAULT_TYPES.OBJECT_SEARCH,
            remote = @Remote(fetcher = "shared/scope_rule", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchField = "name", searchName = "scope_rule"))
    private Long scopeRule;

    @PojoListViewField(actions = {@UIAction(component = "edit"), @UIAction(component = "delete", allowOnMultipleRows = true)}, visible = false)
    @PojoFormElement(available = false)
    private Integer action;

    @Override
    public String asValue() {
        return name;
    }
}
