package systems.dennis.shared.scopes.service;

import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.postgres.service.PaginationService;
import systems.dennis.shared.scopes.form.ScopeRuleForm;
import systems.dennis.shared.scopes.model.ScopeRuleModel;
import systems.dennis.shared.scopes.repository.ScopeRuleRepo;
import systems.dennis.shared.service.AbstractPaginationService;

import java.io.Serializable;

import static systems.dennis.shared.annotations.DeleteStrategy.DELETE_STRATEGY_PROPERTY;

@Service
@DataRetrieverDescription(model = ScopeRuleModel.class, form = ScopeRuleForm.class, repo = ScopeRuleRepo.class)
@DeleteStrategy(value = DELETE_STRATEGY_PROPERTY)
public class ScopeRuleService extends PaginationService<ScopeRuleModel> {

    public ScopeRuleService(WebContext holder) {
        super(holder);
    }

}
