package systems.dennis.shared.scopes.form;

import lombok.Data;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.pojo_form.Checkable;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.DEFAULT_TYPES;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.validation.ValueNotEmptyValidator;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.HIDDEN;

@Data
@PojoListView(actions = {UIAction.ACTION_DOWNLOAD, UIAction.ACTION_NEW, UIAction.ACTION_SETTINGS})
public class ScopeRuleForm implements DefaultForm {
    @PojoFormElement(type = HIDDEN)
    private Long id;

    @PojoFormElement
    @PojoListViewField(searchable = true)
    @Validation(ValueNotEmptyValidator.class)
    private String name;

    @PojoFormElement(type = DEFAULT_TYPES.CHECKBOX, checked = @Checkable, remote = @Remote(searchType = DEFAULT_TYPES.CHECKBOX))
    @PojoListViewField(searchable = true)
    private Boolean verificationRequired;

    @PojoFormElement(type = DEFAULT_TYPES.CHECKBOX, checked = @Checkable, remote = @Remote(searchType = DEFAULT_TYPES.CHECKBOX))
    @PojoListViewField(searchable = true)
    private Boolean registrationAllowed;

    @PojoFormElement(type = DEFAULT_TYPES.CHECKBOX, checked = @Checkable, remote = @Remote(searchType = DEFAULT_TYPES.CHECKBOX))
    @PojoListViewField(searchable = true)
    private Boolean invitationRequired;

    @PojoFormElement(type = "number")
    @PojoListViewField(searchable = true)
    private Integer verificationType;

    @PojoFormElement(type = "number")
    @PojoListViewField(searchable = true)
    private Integer tokenDuration;

    @PojoFormElement(type = "number")
    @PojoListViewField(searchable = true)
    private Integer verificationTokenDuration;


    @PojoFormElement(type = DEFAULT_TYPES.CHECKBOX, checked = @Checkable, remote = @Remote(searchType = DEFAULT_TYPES.CHECKBOX))
    @PojoListViewField(searchable = true)
    private Boolean allowPhoneOperations;

    @PojoFormElement(type = "number")
    @PojoListViewField(searchable = true)
    private Integer triesBeforeBlock;

    @PojoListViewField(actions = {@UIAction(component = "edit"), @UIAction(component = "delete", allowOnMultipleRows = true)}, visible = false)
    @PojoFormElement(available = false)
    private Integer action;

    @Override
    public String asValue() {
        return name;
    }
}
