/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.scopes.service;

import java.util.Date;
import java.util.Objects;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.postgres.service.PaginationService;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.scopes.form.ScopeForm;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.scopes.repository.ScopeRepo;

@Service
@DataRetrieverDescription(model=ScopeModel.class, form=ScopeForm.class, repo=ScopeRepo.class)
@DeleteStrategy(value=2)
public class ScopeService
extends PaginationService<ScopeModel> {
    public ScopeService(WebContext holder) {
        super(holder);
    }

    public ScopeModel preAdd(ScopeModel object) throws ItemForAddContainsIdException {
        object.setDate(new Date());
        return (ScopeModel)super.preAdd((IDPresenter)object);
    }

    public ScopeModel findByName(String name, Long userData, boolean fullAccess) {
        if (name == null) {
            throw new ItemNotFoundException("global.scope.cannot_be_null_in_request");
        }
        AbstractDataFilter filter = this.getFilterImpl().eq("name", (Object)name).and(this.getNotDeletedQuery());
        if (!fullAccess && Objects.nonNull(this.addSelfSpecWithUserScopes(userData))) {
            filter.and(this.addSelfSpecWithUserScopes(userData));
        }
        return (ScopeModel)((Object)this.getRepository().filteredOne(filter).orElseThrow(() -> new ItemNotFoundException(name)));
    }

    public AbstractDataFilter<ScopeModel> addSelfSpecWithUserScopes(Long userData) {
        return null;
    }
}

