package systems.dennis.shared.scopes.controller;

import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.*;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.exceptions.*;
import systems.dennis.shared.postgres.controller.AddItemController;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.postgres.controller.EditItemController;
import systems.dennis.shared.postgres.controller.SelfItemsListController;
import systems.dennis.shared.scopes.form.ScopeRuleForm;
import systems.dennis.shared.scopes.model.ScopeRuleModel;
import systems.dennis.shared.scopes.service.ScopeRuleService;
import systems.dennis.shared.utils.ApplicationContext;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

@RestController
@RequestMapping("/api/v2/shared/scope_rule")
@WebFormsSupport(value = ScopeRuleService.class)
@CrossOrigin
@Secured(roles = "ROLE_ADMIN")
public class ScopeRuleController<ID_TYPE extends Serializable> extends ApplicationContext
        implements AddItemController<ScopeRuleModel, ScopeRuleForm>,
        EditItemController<ScopeRuleModel, ScopeRuleForm>,
        SelfItemsListController<ScopeRuleModel, ScopeRuleForm>,
        DeleteItemController<ScopeRuleModel> {

    static  {
        SearchEntityApi.registerSearch("scope_rule", new SearcherInfo("name", ScopeRuleService.class));
    }

    public ScopeRuleController(WebContext context) {
        super(context);
    }
}
