package systems.dennis.shared.scopes.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.controller.items.AbstractAddItemController;
import systems.dennis.shared.controller.items.AbstractDeleteItemController;
import systems.dennis.shared.controller.items.AbstractEditItemController;
import systems.dennis.shared.controller.items.AbstractListItemController;
import systems.dennis.shared.exceptions.*;
import systems.dennis.shared.postgres.controller.AddItemController;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.postgres.controller.EditItemController;
import systems.dennis.shared.postgres.controller.SelfItemsListController;
import systems.dennis.shared.scopes.form.ScopeForm;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.scopes.service.ScopeService;
import systems.dennis.shared.utils.ApplicationContext;

import java.io.Serializable;
import java.util.List;

@RestController
@RequestMapping("/api/v2/shared/scope")
@WebFormsSupport(value = ScopeService.class)
@CrossOrigin
@Secured (roles = "ROLE_ADMIN")
public class ScopeController extends ApplicationContext
        implements AddItemController<ScopeModel, ScopeForm>,
        EditItemController<ScopeModel, ScopeForm>,
        SelfItemsListController<ScopeModel, ScopeForm>,
        DeleteItemController<ScopeModel> {

    static  {
        SearchEntityApi.registerSearch("scope", new SearcherInfo("name", ScopeService.class));
    }

    public ScopeController(WebContext context) {
        super(context);
    }

    @Override
    @WithRole("ROLE_ADMIN")
    public ResponseEntity<ScopeForm> edit(ScopeForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return EditItemController.super.edit(form);
    }

    @Override
    public ScopeService getService() {
        return AddItemController.super.getService();
    }
}
