package systems.dennis.shared.form;

import lombok.Data;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.validation.ValueNotEmptyValidator;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.HIDDEN;


@Data
@PojoListView (actions = {"settings"}, enableSearching = true)
public class PersonalSettingsForm extends UserAssignableEntity {


    @Validation(ValueNotEmptyValidator.class)
    @PojoFormElement (required = true)
    @PojoListViewField (searchable = true)
    private String name;
    @PojoListViewField(visible = true)
    @PojoFormElement(type = HIDDEN)
    private String type;

    @PojoFormElement (required = true)
    @PojoListViewField (searchable = true, visible = true)
    @Validation (ValueNotEmptyValidator.class)
    private String value;

    @PojoListViewField (visible = false, actions = {  @UIAction(component = "delete") } )
    private int actions;
}
