package systems.dennis.shared.controller;

import org.springframework.web.bind.annotation.*;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.form.PersonalSettingsForm;
import systems.dennis.shared.model.PersonalSettingsModel;
import systems.dennis.shared.service.PersonalSettingsService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping("/api/v2/shared/personal_settings")
@WebFormsSupport(value = PersonalSettingsService.class)
@CrossOrigin
@Secured
public class PersonalSettingsController
        extends ApplicationContext
        implements AddItemController<PersonalSettingsModel, PersonalSettingsForm>,
        ListItemController<PersonalSettingsModel, PersonalSettingsForm>,
        DeleteItemController {

    public PersonalSettingsController(WebContext context) {
        super(context);
    }


    @GetMapping("/by_name")
    public PersonalSettingsForm getByName(@RequestParam ("name") String name){
        return toForm(getService().findFirstByName(name));
    }
    @DeleteMapping("/by_name")
    public PersonalSettingsForm deleteByName(@RequestParam ("name") String name){
        var item = getByName(name);
        getService().delete(item.getId());
        return item;
    }

    @Override
    public PersonalSettingsService getService() {
        return AddItemController.super.getService();
    }
}
