/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.ps.service;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.ps.form.PersonalSettingsForm;
import systems.dennis.shared.ps.model.PersonalSettingsModel;
import systems.dennis.shared.ps.repository.PersonalSettingsRepo;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=PersonalSettingsModel.class, form=PersonalSettingsForm.class, repo=PersonalSettingsRepo.class)
@DeleteStrategy(value=2, selfOnly=true)
public class PersonalSettingsService
extends PaginationService<PersonalSettingsModel> {
    public PersonalSettingsService(WebContext context) {
        super(context);
    }

    public PersonalSettingsModel findFirstByName(String name) {
        DefaultSearchSpecification settings = ((ISecurityUtils)this.getBean(ISecurityUtils.class)).belongsToMeSpecification().addCase(this.getNotDeletedQuery());
        Specification res = settings.and((Specification)QueryCase.equalsOf((String)"name", (Object)name).specification());
        return (PersonalSettingsModel)((Object)this.getRepository().findOne(res).orElseThrow(() -> new ItemNotFoundException(name)));
    }

    public PersonalSettingsModel preAdd(PersonalSettingsModel object) throws ItemForAddContainsIdException {
        try {
            PersonalSettingsModel res = this.findFirstByName(object.getName());
            object.setId(res.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (PersonalSettingsModel)super.preAdd((BaseEntity)object);
    }

    public Specification<PersonalSettingsModel> getAdditionalSpecification() {
        return ((ISecurityUtils)this.getBean(ISecurityUtils.class)).belongsToMeSpecification().addCase(this.getNotDeletedQuery());
    }
}

