/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.ps.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.AddItemController;
import systems.dennis.shared.controller.items.DeleteItemController;
import systems.dennis.shared.controller.items.ListItemController;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.ps.form.PersonalSettingsForm;
import systems.dennis.shared.ps.model.PersonalSettingsModel;
import systems.dennis.shared.ps.service.PersonalSettingsService;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping(value={"/api/v2/shared/personal_settings"})
@WebFormsSupport(value=PersonalSettingsService.class)
@CrossOrigin
@Secured
public class PersonalSettingsController
extends ApplicationContext
implements AddItemController<PersonalSettingsModel, PersonalSettingsForm>,
ListItemController<PersonalSettingsModel, PersonalSettingsForm>,
DeleteItemController {
    public PersonalSettingsController(WebContext context) {
        super(context);
    }

    @GetMapping(value={"/by_name"})
    public PersonalSettingsForm getByName(@RequestParam(value="name") String name) {
        return (PersonalSettingsForm)this.toForm((BaseEntity)this.getService().findFirstByName(name));
    }

    @DeleteMapping(value={"/by_name"})
    public PersonalSettingsForm deleteByName(@RequestParam(value="name") String name) {
        PersonalSettingsForm item = this.getByName(name);
        this.getService().delete(item.getId());
        return item;
    }

    public PersonalSettingsService getService() {
        return (PersonalSettingsService)super.getService();
    }
}

