/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.favorite.service;

import java.util.Optional;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.exceptions.ItemAlreadyExistsException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.favorite.exception.FavoriteException;
import systems.dennis.shared.favorite.form.FavoriteItemForm;
import systems.dennis.shared.favorite.model.FavoriteItemModel;
import systems.dennis.shared.favorite.repository.FavoriteItemRepo;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.postgres.service.PaginationService;
import systems.dennis.shared.repository.AbstractDataFilter;

@Service
@DataRetrieverDescription(model=FavoriteItemModel.class, form=FavoriteItemForm.class, repo=FavoriteItemRepo.class)
public class FavoriteItemService
extends PaginationService<FavoriteItemModel> {
    public static final String GLOBAL_SETTINGS_FAVORITE_ENABLED = "global.settings.favorite.enabled";
    public static final String GLOBAL_SETTINGS_FAVORITE_LIMIT = "global.settings.favorite.limit";

    public FavoriteItemService(WebContext holder) {
        super(holder);
    }

    public FavoriteItemModel preAdd(FavoriteItemModel object) throws ItemForAddContainsIdException {
        if (!this.getIsFavoriteEnabled().booleanValue()) {
            throw new FavoriteException("global.exceptions.favorite.without_type.disabled");
        }
        Long currentUser = (Long)this.getCurrentUser();
        if (object.getType() == null) {
            throw new FavoriteException("global.exceptions.favorite.without_type");
        }
        if (this.existByModelAndUser(object.getModelId(), object.getType(), currentUser).booleanValue()) {
            throw new ItemAlreadyExistsException(object.getModelId().toString());
        }
        object.setUserDataId(currentUser);
        return object;
    }

    public String findBySearchName(String name) {
        return SearchEntityApi.findServiceByType((String)name).getAnnotation(DataRetrieverDescription.class).form().getSimpleName();
    }

    public void delete(FavoriteItemForm id) throws ItemNotUserException, ItemNotFoundException {
        id.setUserDataId((Long)this.getCurrentUser());
        Optional<FavoriteItemModel> item = this.findByModelAndUser(id.getModelId(), id.getType(), id.getUserDataId());
        item.ifPresent(favoriteItemModel -> this.delete(favoriteItemModel.getId()));
    }

    public Boolean getIsFavoriteEnabled() {
        return (Boolean)this.getContext().getEnv(GLOBAL_SETTINGS_FAVORITE_ENABLED, (Object)true);
    }

    public boolean isFavoriteForObject(FavoriteItemForm form) {
        form.setUserDataId((Long)this.getCurrentUser());
        if (form.getModelId() == null) {
            throw new FavoriteException("global.exceptions.favorite.favorite.no_model_id");
        }
        return this.existByModelAndUser(form.getModelId(), form.getType(), form.getUserDataId());
    }

    public boolean isFavoriteForObject(BaseEntity entity) {
        if (!this.getIsFavoriteEnabled().booleanValue()) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        String entityDescriptor = entity.getClass().getSimpleName();
        if (entity.getClass().getAnnotation(PojoListView.class) != null) {
            entityDescriptor = entityDescriptor.getClass().getAnnotation(PojoListView.class).favoriteType();
        }
        return this.existByModelAndUser(entity.getId(), entityDescriptor, (Long)this.getCurrentUser());
    }

    private Boolean existByModelAndUser(Long modelId, String entityDescriptor, Long currentUser) {
        if (!this.getIsFavoriteEnabled().booleanValue()) {
            return false;
        }
        long count = this.getRepository().filteredCount(this.getFilterImpl().eq("userDataId", (Object)currentUser).and(this.getFilterImpl().eq("type", (Object)entityDescriptor)).and(this.getFilterImpl().eq("modelId", (Object)modelId)));
        return count > 0L;
    }

    private Optional<FavoriteItemModel> findByModelAndUser(Long modelId, String entityDescriptor, Long currentUser) {
        if (!this.getIsFavoriteEnabled().booleanValue()) {
            return Optional.empty();
        }
        return this.getRepository().filteredOne(this.getFilterImpl().eq("userDataId", (Object)currentUser).and(this.getFilterImpl().eq("type", (Object)entityDescriptor)).and(this.getFilterImpl().eq("modelId", (Object)modelId)));
    }

    public boolean isFavoriteLimitNotExceeded(FavoriteItemForm form) {
        if (!this.getIsFavoriteEnabled().booleanValue()) {
            return false;
        }
        if (((ISecurityUtils)this.getContext().getBean(ISecurityUtils.class)).isAdmin()) {
            return true;
        }
        Long favoriteStoreLimit = (Long)this.getContext().getEnv(GLOBAL_SETTINGS_FAVORITE_LIMIT, (Object)100L);
        long count = this.getRepository().filteredCount(this.getSelfCreatedItemsQuery(this.getCurrentUser()).and(this.getFilterImpl().eq("type", (Object)form.getType())));
        return count < favoriteStoreLimit;
    }

    public AbstractDataFilter<FavoriteItemModel> getAdditionalSpecification() {
        AbstractDataFilter res = super.getAdditionalSpecification();
        res = res.and(this.getFilterImpl().ofUser(FavoriteItemModel.class, this.getCurrentUser()));
        return res;
    }
}

