package systems.dennis.shared.favorite.model;

import jakarta.persistence.Entity;
import lombok.Data;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.entity.Created;
import systems.dennis.shared.annotations.entity.CreatedBy;
import systems.dennis.shared.postgres.model.BaseEntity;

@Data
@Entity
public class FavoriteItemModel extends BaseEntity {

    private Long modelId;

    private String type;

    @CreatedBy
    @FormTransient
    private Long userDataId;

    @Override
    public String asValue() {
        return type + "model_" +  getId()  + userDataId ;
    }
}
