package systems.dennis.shared.favorite.form;

import lombok.Data;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.favorite.validation.FavoriteStoreLimitValidator;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.postgres.form.DefaultForm;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.HIDDEN;

@Data
@PojoListView(actions = {})
public class FavoriteItemForm implements DefaultForm {

    @PojoFormElement(type = HIDDEN)
    private Long id;

    private Long modelId;

    @PojoFormElement(required = true)
    @PojoListViewField(searchable = true)
    private String type;

    @PojoFormElement (available = false)
    @PojoListViewField( available = false)
    @Validation(FavoriteStoreLimitValidator.class)
    private Long userDataId;

    @PojoListViewField(actions = {@UIAction(component = "delete")})
    @PojoFormElement(available = false)
    private Integer action;

    @Override
    public String asValue() {
        return type + " "  + userDataId + " " + modelId;
    }
}
