package systems.dennis.shared.scopes.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.scopes.repository.DictionaryRepo;
import systems.dennis.shared.exceptions.DictionaryException;
import systems.dennis.shared.scopes.form.DictionaryForm;
import systems.dennis.shared.scopes.model.DictionaryModel;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

import java.util.List;

@Service
@DataRetrieverDescription(model =  DictionaryModel.class, form = DictionaryForm.class, repo =  DictionaryRepo.class)
public class DictionaryService extends PaginationService<DictionaryModel> {
    public DictionaryService(WebContext holder) {
        super(holder);
    }

    @Override
    public Page<DictionaryModel> search(String field, String subtype, String value, int page, Integer size, Long[] additionalIds) {


        try {
            Specification<DictionaryModel> spec = getSearchRequestSpecification(DictionaryModel.DICTIONARY_FIELD, value, additionalIds);
            spec = spec.and(QueryCase.equalsOf("type", subtype).specification());
            return getRepository().findAll(spec, PageRequest.of(page, size, Sort.by(Sort.Direction.DESC, DictionaryModel.DICTIONARY_FIELD)));
        } catch (Exception e){
            throw new DictionaryException("global.search.dictionary.failed", HttpStatus.BAD_REQUEST);
        }

    }

    @Override
    public boolean isPublicSearchEnabled() {
        return true;
    }

    @Override
    public DictionaryRepo getRepository() {
        return super.getRepository();
    }

    public List<String> getDictionaryTypes() {
        return getRepository().getDictionaryTypes();
    }
}
