package systems.dennis.shared.scopes.repository;

import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import systems.dennis.shared.scopes.model.DictionaryModel;
import systems.dennis.shared.repository.PaginationRepository;

import java.util.List;

@Repository
public interface DictionaryRepo extends PaginationRepository<DictionaryModel> {

    @Query (nativeQuery = true, value = "select distinct type from dictionary_model")
    List<String> getDictionaryTypes();
}
